/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8285.DeviceView;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8285.DeviceView.BankLike;
import ibm.nways.jdm8285.DeviceView.BayLike;
import ibm.nways.jdm8285.DeviceView.BuilderLike;
import ibm.nways.jdm8285.DeviceView.ChassisInfoLike;
import ibm.nways.jdm8285.DeviceView.ChassisLike;
import ibm.nways.jdm8285.DeviceView.Factory;
import ibm.nways.jdm8285.DeviceView.FactoryLike;
import ibm.nways.jdm8285.DeviceView.ModuleLike;
import ibm.nways.jdm8285.DeviceView.PortLike;
import ibm.nways.ras.RAS;
import java.awt.Point;
import java.io.Serializable;

public class Builder
implements BuilderLike {
    private static final Builder instance = new Builder();
    private static FactoryLike factory = Factory.getInstance();

    private Builder() {
    }

    public static BuilderLike getInstance() {
        return instance;
    }

    public ChassisLike buildChassis(JdmBrowser jdmBrowser) {
        Object object;
        String string = "buildChassis";
        if (RAS.isEnabled(19, 6)) {
            RAS.enter(19, 6, this, string);
        }
        GenModel genModel = (GenModel)jdmBrowser.getModel();
        Serializable serializable = null;
        try {
            object = genModel.getInfo("Config");
            serializable = ((ModelInfo)object).get("Config.SysObjectID");
        }
        catch (Exception exception) {
            RAS.logException(19, 6, this, string, exception);
        }
        object = Factory.getInstance().createChassis(serializable);
        GraphicContainer graphicContainer = new GraphicContainer();
        object.setCommonInformation(jdmBrowser, genModel, (ChassisInfoLike)object, graphicContainer);
        object.discoverChildren();
        if (RAS.isEnabled(19, 6)) {
            RAS.exit(19, 6, this, string);
        }
        return object;
    }

    public ChassisLike buildChassisExpansion(JdmBrowser jdmBrowser, GraphicContainer graphicContainer, ChassisInfoLike chassisInfoLike) {
        Object object;
        String string = "buildChassisExpansion";
        if (RAS.isEnabled(19, 6)) {
            RAS.enter(19, 6, this, string);
        }
        GenModel genModel = (GenModel)jdmBrowser.getModel();
        Serializable serializable = null;
        try {
            object = (GenModel)genModel.getComponent("ExpansionScalars");
            ModelInfo modelInfo = object.getInfo("Panel");
            serializable = modelInfo.get("ExpansionScalars.ExpansionHardwareVersion");
        }
        catch (Exception exception) {
            RAS.logException(19, 6, this, string, exception);
        }
        object = Factory.getInstance().createChassisExpansion();
        object.setCommonInformation(jdmBrowser, genModel, chassisInfoLike, graphicContainer);
        object.discoverChildren();
        if (RAS.isEnabled(19, 6)) {
            RAS.exit(19, 6, this, string);
        }
        return object;
    }

    public ModuleLike buildModule(ChassisInfoLike chassisInfoLike, int n, Serializable serializable, GraphicContainer graphicContainer, GenModel genModel) {
        String string = "buildModule";
        if (RAS.isEnabled(19, 6)) {
            RAS.enter(19, 6, this, string);
        }
        int n2 = (Integer)serializable;
        ModuleLike moduleLike = factory.createModule(chassisInfoLike, n, n2);
        moduleLike.setCommonInformation(chassisInfoLike, n, graphicContainer, genModel);
        moduleLike.setSpecificInformation();
        moduleLike.discoverChildren();
        if (RAS.isEnabled(19, 6)) {
            RAS.exit(19, 6, this, string);
        }
        return moduleLike;
    }

    public PortLike buildPort(ChassisInfoLike chassisInfoLike, String string, int n, int n2, int n3, int n4, GraphicContainer graphicContainer, String string2, GenModel genModel) {
        String string3 = "buildPort";
        if (RAS.isEnabled(19, 6)) {
            RAS.enter(19, 6, this, string3);
        }
        PortLike portLike = null;
        try {
            portLike = factory.createPort(n4);
            portLike.setCommonInformation(chassisInfoLike, string, n, n2, n3, graphicContainer, string2, genModel);
            portLike.setSpecificInformation();
        }
        catch (Exception exception) {
            RAS.logException(19, 6, this, string3, exception);
        }
        if (RAS.isEnabled(19, 6)) {
            RAS.exit(19, 6, this, string3);
        }
        return portLike;
    }

    public BankLike buildBank(ChassisInfoLike chassisInfoLike, int n, int n2, int n3, int n4, Point point, GraphicContainer graphicContainer, String string, GenModel genModel) {
        String string2 = "buildBank";
        if (RAS.isEnabled(19, 6)) {
            RAS.enter(19, 6, this, string2);
        }
        BankLike bankLike = factory.createBank(n3);
        bankLike.setCommonInformation(chassisInfoLike, n, n2, point, graphicContainer, n4, string, genModel);
        bankLike.discoverChildren();
        if (RAS.isEnabled(19, 6)) {
            RAS.exit(19, 6, this, string2);
        }
        return bankLike;
    }

    public BayLike buildBay(ChassisInfoLike chassisInfoLike, int n, int n2, Serializable serializable, int n3, int n4, Point point, GraphicContainer graphicContainer, String string, GenModel genModel) {
        String string2 = "buildBay";
        if (RAS.isEnabled(19, 6)) {
            RAS.enter(19, 6, this, string2);
        }
        BayLike bayLike = factory.createBay(n, (Integer)serializable);
        bayLike.setCommonInformation(chassisInfoLike, n, n2, n3, point, graphicContainer, n4, string, genModel);
        bayLike.setSpecificInformation();
        bayLike.discoverChildren();
        if (RAS.isEnabled(19, 6)) {
            RAS.exit(19, 6, this, string2);
        }
        return bayLike;
    }
}

